#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    int N, M, K, L;
    cin >> N >> M >> K >> L;

    vector<int> A(N * M);
    for (int i = 0; i < N * M; ++i) {
        cin >> A[i];
    }

    vector<vector<int>> counts(N, vector<int>(M, 0));

    for (int i = 0; i <= N - K; ++i) {
        for (int j = 0; j <= M - L; ++j) {
            for (int x = i; x < i + K; ++x) {
                for (int y = j; y < j + L; ++y) {
                    counts[x][y]++;
                }
            }
        }
    }

    vector<int> occurrences;

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            occurrences.push_back(counts[i][j]);
        }
    }

    sort(occurrences.begin(), occurrences.end(), greater<int>());
    sort(A.begin(), A.end(), greater<int>());

    long long int result = 0;

    for (int i = 0; i < N * M; ++i) {
        result += static_cast<long long>(occurrences[i]) * A[i];
    }

    cout << result << endl;

    return 0;
}